/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
ComboBox combobox_a, // combobox
         combobox_b; // combobox

struct ComboBoxElm // combobox element structure
{
   VecI2 vec;
}veci2[]=
{
   {VecI2(0, 0)},
   {VecI2(0,10)},
   {VecI2(0,20)},
   {VecI2(1, 0)},
   {VecI2(1,10)},
   {VecI2(1,20)},
};

Char* ComboBoxElmFunc(ComboBoxElm &elm) // function which transforms ComboBoxElm into a string
{
   static Str str;
   return str.set("%d x %d",elm.vec.x,elm.vec.y);
}
/******************************************************************************/
void InitPre()
{
   App.name="ComboBox";
   App.flag=APP_FULL_TOGGLE|APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   // combobox A (from text-only elements)
   {
      static Char *elm[]= // combobox elements (must be non-local)
      {
         "First",
         "Second",
         "Third",
      };
      Gui+=combobox_a.create(Rect_C(-0.5,0, 0.4,0.08),elm,ELMS(elm)); // create combobox with simple elements (text-only)
   }

   // combobox B (from custom structure)
   {
      ListGroup lg[]= // list groups
      {
         ListGroup(DATA_TEXTP,ComboBoxElmFunc,0,0.3,"Function"), // list group which uses custom function for data interpretation
      };
      Gui+=combobox_b.create(Rect_C(0.5,0, 0.4,0.08)); // create combobox

      // assign custom elements
      combobox_b.setGroups(lg   ,ELMS(lg   ),true)  // set list groups
                .setData  (veci2,ELMS(veci2)     ); // set list data
   }

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   D.text (-0.5, 0.1,S+"combobox_a element: "+combobox_a()); // draw selected element
   D.text ( 0.5, 0.1,S+"combobox_b element: "+combobox_b()); // draw selected element
   Gui.draw();
}
/******************************************************************************/
